package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait MFADelete {
  def unwrap: software.amazon.awssdk.services.s3.model.MFADelete
}
object MFADelete {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.MFADelete
  ): zio.aws.s3.model.MFADelete = value match {
    case software.amazon.awssdk.services.s3.model.MFADelete.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.MFADelete.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.MFADelete.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.MFADelete {
    override def unwrap: software.amazon.awssdk.services.s3.model.MFADelete =
      software.amazon.awssdk.services.s3.model.MFADelete.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.MFADelete {
    override def unwrap: software.amazon.awssdk.services.s3.model.MFADelete =
      software.amazon.awssdk.services.s3.model.MFADelete.ENABLED
  }
  case object Disabled extends zio.aws.s3.model.MFADelete {
    override def unwrap: software.amazon.awssdk.services.s3.model.MFADelete =
      software.amazon.awssdk.services.s3.model.MFADelete.DISABLED
  }
}
