package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Initiated, ObjectKey, MultipartUploadId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MultipartUpload(
    uploadId: Option[MultipartUploadId] = None,
    key: Option[ObjectKey] = None,
    initiated: Option[Initiated] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    owner: Option[zio.aws.s3.model.Owner] = None,
    initiator: Option[zio.aws.s3.model.Initiator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MultipartUpload = {
    import MultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MultipartUpload
      .builder()
      .optionallyWith(
        uploadId.map(value => MultipartUploadId.unwrap(value): java.lang.String)
      )(_.uploadId)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(initiated.map(value => Initiated.unwrap(value): Instant))(
        _.initiated
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MultipartUpload.ReadOnly =
    zio.aws.s3.model.MultipartUpload.wrap(buildAwsValue())
}
object MultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MultipartUpload =
      zio.aws.s3.model.MultipartUpload(
        uploadId.map(value => value),
        key.map(value => value),
        initiated.map(value => value),
        storageClass.map(value => value),
        owner.map(value => value.asEditable),
        initiator.map(value => value.asEditable)
      )
    def uploadId: Option[MultipartUploadId]
    def key: Option[ObjectKey]
    def initiated: Option[Initiated]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def owner: Option[zio.aws.s3.model.Owner.ReadOnly]
    def initiator: Option[zio.aws.s3.model.Initiator.ReadOnly]
    def getUploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadId)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getInitiated: ZIO[Any, AwsError, Initiated] =
      AwsError.unwrapOptionField("initiated", initiated)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getInitiator: ZIO[Any, AwsError, zio.aws.s3.model.Initiator.ReadOnly] =
      AwsError.unwrapOptionField("initiator", initiator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MultipartUpload
  ) extends zio.aws.s3.model.MultipartUpload.ReadOnly {
    override val uploadId: Option[MultipartUploadId] = scala
      .Option(impl.uploadId())
      .map(value => zio.aws.s3.model.primitives.MultipartUploadId(value))
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val initiated: Option[Initiated] = scala
      .Option(impl.initiated())
      .map(value => zio.aws.s3.model.primitives.Initiated(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val owner: Option[zio.aws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val initiator: Option[zio.aws.s3.model.Initiator.ReadOnly] = scala
      .Option(impl.initiator())
      .map(value => zio.aws.s3.model.Initiator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MultipartUpload
  ): zio.aws.s3.model.MultipartUpload.ReadOnly = new Wrapper(impl)
}
