package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{VersionCount, Days}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NoncurrentVersionExpiration(
    noncurrentDays: Option[Days] = None,
    newerNoncurrentVersions: Option[VersionCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration = {
    import NoncurrentVersionExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(
        newerNoncurrentVersions.map(value =>
          VersionCount.unwrap(value): Integer
        )
      )(_.newerNoncurrentVersions)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly =
    zio.aws.s3.model.NoncurrentVersionExpiration.wrap(buildAwsValue())
}
object NoncurrentVersionExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.NoncurrentVersionExpiration =
      zio.aws.s3.model.NoncurrentVersionExpiration(
        noncurrentDays.map(value => value),
        newerNoncurrentVersions.map(value => value)
      )
    def noncurrentDays: Option[Days]
    def newerNoncurrentVersions: Option[VersionCount]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getNewerNoncurrentVersions: ZIO[Any, AwsError, VersionCount] = AwsError
      .unwrapOptionField("newerNoncurrentVersions", newerNoncurrentVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ) extends zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly {
    override val noncurrentDays: Option[Days] = scala
      .Option(impl.noncurrentDays())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val newerNoncurrentVersions: Option[VersionCount] = scala
      .Option(impl.newerNoncurrentVersions())
      .map(value => zio.aws.s3.model.primitives.VersionCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ): zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly = new Wrapper(impl)
}
