package zio.aws.s3.model
import zio.aws.s3.model.primitives.{ObjectVersionId, ObjectKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ObjectIdentifier(
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectIdentifier = {
    import ObjectIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectIdentifier
      .builder()
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectIdentifier.ReadOnly =
    zio.aws.s3.model.ObjectIdentifier.wrap(buildAwsValue())
}
object ObjectIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectIdentifier =
      zio.aws.s3.model.ObjectIdentifier(key, versionId.map(value => value))
    def key: ObjectKey
    def versionId: Option[ObjectVersionId]
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectIdentifier
  ) extends zio.aws.s3.model.ObjectIdentifier.ReadOnly {
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectIdentifier
  ): zio.aws.s3.model.ObjectIdentifier.ReadOnly = new Wrapper(impl)
}
