package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectLockMode {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectLockMode
}
object ObjectLockMode {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectLockMode
  ): zio.aws.s3.model.ObjectLockMode = value match {
    case software.amazon.awssdk.services.s3.model.ObjectLockMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectLockMode.GOVERNANCE =>
      val r = GOVERNANCE
      r
    case software.amazon.awssdk.services.s3.model.ObjectLockMode.COMPLIANCE =>
      val r = COMPLIANCE
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ObjectLockMode {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockMode =
      software.amazon.awssdk.services.s3.model.ObjectLockMode.UNKNOWN_TO_SDK_VERSION
  }
  case object GOVERNANCE extends zio.aws.s3.model.ObjectLockMode {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockMode =
      software.amazon.awssdk.services.s3.model.ObjectLockMode.GOVERNANCE
  }
  case object COMPLIANCE extends zio.aws.s3.model.ObjectLockMode {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockMode =
      software.amazon.awssdk.services.s3.model.ObjectLockMode.COMPLIANCE
  }
}
