package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectStorageClass {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectStorageClass
}
object ObjectStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectStorageClass
  ): zio.aws.s3.model.ObjectStorageClass = value match {
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.REDUCED_REDUNDANCY =>
      val r = REDUCED_REDUNDANCY
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.OUTPOSTS =>
      val r = OUTPOSTS
      r
    case software.amazon.awssdk.services.s3.model.ObjectStorageClass.GLACIER_IR =>
      val r = GLACIER_IR
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.STANDARD
  }
  case object REDUCED_REDUNDANCY extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.REDUCED_REDUNDANCY
  }
  case object GLACIER extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.GLACIER
  }
  case object STANDARD_IA extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.STANDARD_IA
  }
  case object ONEZONE_IA extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.INTELLIGENT_TIERING
  }
  case object DEEP_ARCHIVE extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.DEEP_ARCHIVE
  }
  case object OUTPOSTS extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.OUTPOSTS
  }
  case object GLACIER_IR extends zio.aws.s3.model.ObjectStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectStorageClass.GLACIER_IR
  }
}
