package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{ETag, LastModified, PartNumber}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Part(
    partNumber: Option[PartNumber] = None,
    lastModified: Option[LastModified] = None,
    eTag: Option[ETag] = None,
    size: Option[Long] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Part = {
    import Part.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Part
      .builder()
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Part.ReadOnly =
    zio.aws.s3.model.Part.wrap(buildAwsValue())
}
object Part {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Part] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Part = zio.aws.s3.model.Part(
      partNumber.map(value => value),
      lastModified.map(value => value),
      eTag.map(value => value),
      size.map(value => value)
    )
    def partNumber: Option[PartNumber]
    def lastModified: Option[LastModified]
    def eTag: Option[ETag]
    def size: Option[Long]
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Part
  ) extends zio.aws.s3.model.Part.ReadOnly {
    override val partNumber: Option[PartNumber] = scala
      .Option(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val size: Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Part
  ): zio.aws.s3.model.Part.ReadOnly = new Wrapper(impl)
}
