package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketAccelerateConfigurationRequest(
    bucket: BucketName,
    accelerateConfiguration: zio.aws.s3.model.AccelerateConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest = {
    import PutBucketAccelerateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .accelerateConfiguration(accelerateConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketAccelerateConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketAccelerateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketAccelerateConfigurationRequest =
      zio.aws.s3.model.PutBucketAccelerateConfigurationRequest(
        bucket,
        accelerateConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def accelerateConfiguration
        : zio.aws.s3.model.AccelerateConfiguration.ReadOnly
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getAccelerateConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.AccelerateConfiguration.ReadOnly] =
      ZIO.succeed(accelerateConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val accelerateConfiguration
        : zio.aws.s3.model.AccelerateConfiguration.ReadOnly =
      zio.aws.s3.model.AccelerateConfiguration
        .wrap(impl.accelerateConfiguration())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ): zio.aws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
