package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  GrantRead,
  GrantReadACP,
  AccountId,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  GrantWrite
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketAclRequest(
    acl: Option[zio.aws.s3.model.BucketCannedACL] = None,
    accessControlPolicy: Option[zio.aws.s3.model.AccessControlPolicy] = None,
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWrite: Option[GrantWrite] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAclRequest = {
    import PutBucketAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAclRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .optionallyWith(accessControlPolicy.map(value => value.buildAwsValue()))(
        _.accessControlPolicy
      )
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWrite.map(value => GrantWrite.unwrap(value): java.lang.String)
      )(_.grantWrite)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketAclRequest.ReadOnly =
    zio.aws.s3.model.PutBucketAclRequest.wrap(buildAwsValue())
}
object PutBucketAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketAclRequest =
      zio.aws.s3.model.PutBucketAclRequest(
        acl.map(value => value),
        accessControlPolicy.map(value => value.asEditable),
        bucket,
        contentMD5.map(value => value),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWrite.map(value => value),
        grantWriteACP.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def acl: Option[zio.aws.s3.model.BucketCannedACL]
    def accessControlPolicy
        : Option[zio.aws.s3.model.AccessControlPolicy.ReadOnly]
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def grantFullControl: Option[GrantFullControl]
    def grantRead: Option[GrantRead]
    def grantReadACP: Option[GrantReadACP]
    def grantWrite: Option[GrantWrite]
    def grantWriteACP: Option[GrantWriteACP]
    def expectedBucketOwner: Option[AccountId]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.BucketCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getAccessControlPolicy
        : ZIO[Any, AwsError, zio.aws.s3.model.AccessControlPolicy.ReadOnly] =
      AwsError.unwrapOptionField("accessControlPolicy", accessControlPolicy)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWrite)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAclRequest
  ) extends zio.aws.s3.model.PutBucketAclRequest.ReadOnly {
    override val acl: Option[zio.aws.s3.model.BucketCannedACL] = scala
      .Option(impl.acl())
      .map(value => zio.aws.s3.model.BucketCannedACL.wrap(value))
    override val accessControlPolicy
        : Option[zio.aws.s3.model.AccessControlPolicy.ReadOnly] = scala
      .Option(impl.accessControlPolicy())
      .map(value => zio.aws.s3.model.AccessControlPolicy.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val grantFullControl: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Option[GrantRead] = scala
      .Option(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Option[GrantReadACP] = scala
      .Option(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWrite: Option[GrantWrite] = scala
      .Option(impl.grantWrite())
      .map(value => zio.aws.s3.model.primitives.GrantWrite(value))
    override val grantWriteACP: Option[GrantWriteACP] = scala
      .Option(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAclRequest
  ): zio.aws.s3.model.PutBucketAclRequest.ReadOnly = new Wrapper(impl)
}
