package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketLoggingRequest(
    bucket: BucketName,
    bucketLoggingStatus: zio.aws.s3.model.BucketLoggingStatus,
    contentMD5: Option[ContentMD5] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest = {
    import PutBucketLoggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .bucketLoggingStatus(bucketLoggingStatus.buildAwsValue())
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketLoggingRequest.ReadOnly =
    zio.aws.s3.model.PutBucketLoggingRequest.wrap(buildAwsValue())
}
object PutBucketLoggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketLoggingRequest =
      zio.aws.s3.model.PutBucketLoggingRequest(
        bucket,
        bucketLoggingStatus.asEditable,
        contentMD5.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def bucketLoggingStatus: zio.aws.s3.model.BucketLoggingStatus.ReadOnly
    def contentMD5: Option[ContentMD5]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getBucketLoggingStatus
        : ZIO[Any, Nothing, zio.aws.s3.model.BucketLoggingStatus.ReadOnly] =
      ZIO.succeed(bucketLoggingStatus)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
  ) extends zio.aws.s3.model.PutBucketLoggingRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val bucketLoggingStatus
        : zio.aws.s3.model.BucketLoggingStatus.ReadOnly =
      zio.aws.s3.model.BucketLoggingStatus.wrap(impl.bucketLoggingStatus())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
  ): zio.aws.s3.model.PutBucketLoggingRequest.ReadOnly = new Wrapper(impl)
}
