package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketOwnershipControlsRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    expectedBucketOwner: Option[AccountId] = None,
    ownershipControls: zio.aws.s3.model.OwnershipControls
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest = {
    import PutBucketOwnershipControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .ownershipControls(ownershipControls.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketOwnershipControlsRequest.ReadOnly =
    zio.aws.s3.model.PutBucketOwnershipControlsRequest.wrap(buildAwsValue())
}
object PutBucketOwnershipControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketOwnershipControlsRequest =
      zio.aws.s3.model.PutBucketOwnershipControlsRequest(
        bucket,
        contentMD5.map(value => value),
        expectedBucketOwner.map(value => value),
        ownershipControls.asEditable
      )
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def expectedBucketOwner: Option[AccountId]
    def ownershipControls: zio.aws.s3.model.OwnershipControls.ReadOnly
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getOwnershipControls
        : ZIO[Any, Nothing, zio.aws.s3.model.OwnershipControls.ReadOnly] =
      ZIO.succeed(ownershipControls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
  ) extends zio.aws.s3.model.PutBucketOwnershipControlsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val ownershipControls
        : zio.aws.s3.model.OwnershipControls.ReadOnly =
      zio.aws.s3.model.OwnershipControls.wrap(impl.ownershipControls())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
  ): zio.aws.s3.model.PutBucketOwnershipControlsRequest.ReadOnly = new Wrapper(
    impl
  )
}
