package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  AccountId,
  ConfirmRemoveSelfBucketAccess,
  Policy,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketPolicyRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    confirmRemoveSelfBucketAccess: Option[ConfirmRemoveSelfBucketAccess] = None,
    policy: Policy,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest = {
    import PutBucketPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        confirmRemoveSelfBucketAccess.map(value =>
          ConfirmRemoveSelfBucketAccess.unwrap(value): java.lang.Boolean
        )
      )(_.confirmRemoveSelfBucketAccess)
      .policy(Policy.unwrap(policy): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketPolicyRequest.ReadOnly =
    zio.aws.s3.model.PutBucketPolicyRequest.wrap(buildAwsValue())
}
object PutBucketPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketPolicyRequest =
      zio.aws.s3.model.PutBucketPolicyRequest(
        bucket,
        contentMD5.map(value => value),
        confirmRemoveSelfBucketAccess.map(value => value),
        policy,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def confirmRemoveSelfBucketAccess: Option[ConfirmRemoveSelfBucketAccess]
    def policy: Policy
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getConfirmRemoveSelfBucketAccess
        : ZIO[Any, AwsError, ConfirmRemoveSelfBucketAccess] =
      AwsError.unwrapOptionField(
        "confirmRemoveSelfBucketAccess",
        confirmRemoveSelfBucketAccess
      )
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ) extends zio.aws.s3.model.PutBucketPolicyRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val confirmRemoveSelfBucketAccess
        : Option[ConfirmRemoveSelfBucketAccess] = scala
      .Option(impl.confirmRemoveSelfBucketAccess())
      .map(value =>
        zio.aws.s3.model.primitives.ConfirmRemoveSelfBucketAccess(value)
      )
    override val policy: Policy =
      zio.aws.s3.model.primitives.Policy(impl.policy())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ): zio.aws.s3.model.PutBucketPolicyRequest.ReadOnly = new Wrapper(impl)
}
