package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  ObjectLockToken,
  ContentMD5,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketReplicationRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    replicationConfiguration: zio.aws.s3.model.ReplicationConfiguration,
    token: Option[ObjectLockToken] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest = {
    import PutBucketReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .replicationConfiguration(replicationConfiguration.buildAwsValue())
      .optionallyWith(
        token.map(value => ObjectLockToken.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketReplicationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketReplicationRequest.wrap(buildAwsValue())
}
object PutBucketReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketReplicationRequest =
      zio.aws.s3.model.PutBucketReplicationRequest(
        bucket,
        contentMD5.map(value => value),
        replicationConfiguration.asEditable,
        token.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def replicationConfiguration
        : zio.aws.s3.model.ReplicationConfiguration.ReadOnly
    def token: Option[ObjectLockToken]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getReplicationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.ReplicationConfiguration.ReadOnly
    ] = ZIO.succeed(replicationConfiguration)
    def getToken: ZIO[Any, AwsError, ObjectLockToken] =
      AwsError.unwrapOptionField("token", token)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
  ) extends zio.aws.s3.model.PutBucketReplicationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val replicationConfiguration
        : zio.aws.s3.model.ReplicationConfiguration.ReadOnly =
      zio.aws.s3.model.ReplicationConfiguration
        .wrap(impl.replicationConfiguration())
    override val token: Option[ObjectLockToken] = scala
      .Option(impl.token())
      .map(value => zio.aws.s3.model.primitives.ObjectLockToken(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
  ): zio.aws.s3.model.PutBucketReplicationRequest.ReadOnly = new Wrapper(impl)
}
