package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketRequestPaymentRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    requestPaymentConfiguration: zio.aws.s3.model.RequestPaymentConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest = {
    import PutBucketRequestPaymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .requestPaymentConfiguration(requestPaymentConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketRequestPaymentRequest.ReadOnly =
    zio.aws.s3.model.PutBucketRequestPaymentRequest.wrap(buildAwsValue())
}
object PutBucketRequestPaymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketRequestPaymentRequest =
      zio.aws.s3.model.PutBucketRequestPaymentRequest(
        bucket,
        contentMD5.map(value => value),
        requestPaymentConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def requestPaymentConfiguration
        : zio.aws.s3.model.RequestPaymentConfiguration.ReadOnly
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getRequestPaymentConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.RequestPaymentConfiguration.ReadOnly
    ] = ZIO.succeed(requestPaymentConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest
  ) extends zio.aws.s3.model.PutBucketRequestPaymentRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val requestPaymentConfiguration
        : zio.aws.s3.model.RequestPaymentConfiguration.ReadOnly =
      zio.aws.s3.model.RequestPaymentConfiguration
        .wrap(impl.requestPaymentConfiguration())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest
  ): zio.aws.s3.model.PutBucketRequestPaymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
