package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketTaggingRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    tagging: zio.aws.s3.model.Tagging,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest = {
    import PutBucketTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .tagging(tagging.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketTaggingRequest.ReadOnly =
    zio.aws.s3.model.PutBucketTaggingRequest.wrap(buildAwsValue())
}
object PutBucketTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketTaggingRequest =
      zio.aws.s3.model.PutBucketTaggingRequest(
        bucket,
        contentMD5.map(value => value),
        tagging.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def tagging: zio.aws.s3.model.Tagging.ReadOnly
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getTagging: ZIO[Any, Nothing, zio.aws.s3.model.Tagging.ReadOnly] =
      ZIO.succeed(tagging)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest
  ) extends zio.aws.s3.model.PutBucketTaggingRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val tagging: zio.aws.s3.model.Tagging.ReadOnly =
      zio.aws.s3.model.Tagging.wrap(impl.tagging())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest
  ): zio.aws.s3.model.PutBucketTaggingRequest.ReadOnly = new Wrapper(impl)
}
