package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutObjectAclResponse(
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectAclResponse = {
    import PutObjectAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectAclResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectAclResponse.ReadOnly =
    zio.aws.s3.model.PutObjectAclResponse.wrap(buildAwsValue())
}
object PutObjectAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectAclResponse =
      zio.aws.s3.model.PutObjectAclResponse(requestCharged.map(value => value))
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectAclResponse
  ) extends zio.aws.s3.model.PutObjectAclResponse.ReadOnly {
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectAclResponse
  ): zio.aws.s3.model.PutObjectAclResponse.ReadOnly = new Wrapper(impl)
}
