package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  ContentMD5,
  ObjectLockToken,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutObjectLockConfigurationRequest(
    bucket: BucketName,
    objectLockConfiguration: Option[zio.aws.s3.model.ObjectLockConfiguration] =
      None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    token: Option[ObjectLockToken] = None,
    contentMD5: Option[ContentMD5] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest = {
    import PutObjectLockConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        objectLockConfiguration.map(value => value.buildAwsValue())
      )(_.objectLockConfiguration)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        token.map(value => ObjectLockToken.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectLockConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutObjectLockConfigurationRequest.wrap(buildAwsValue())
}
object PutObjectLockConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectLockConfigurationRequest =
      zio.aws.s3.model.PutObjectLockConfigurationRequest(
        bucket,
        objectLockConfiguration.map(value => value.asEditable),
        requestPayer.map(value => value),
        token.map(value => value),
        contentMD5.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def objectLockConfiguration
        : Option[zio.aws.s3.model.ObjectLockConfiguration.ReadOnly]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def token: Option[ObjectLockToken]
    def contentMD5: Option[ContentMD5]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getObjectLockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.ObjectLockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectLockConfiguration",
      objectLockConfiguration
    )
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getToken: ZIO[Any, AwsError, ObjectLockToken] =
      AwsError.unwrapOptionField("token", token)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
  ) extends zio.aws.s3.model.PutObjectLockConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val objectLockConfiguration
        : Option[zio.aws.s3.model.ObjectLockConfiguration.ReadOnly] = scala
      .Option(impl.objectLockConfiguration())
      .map(value => zio.aws.s3.model.ObjectLockConfiguration.wrap(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val token: Option[ObjectLockToken] = scala
      .Option(impl.token())
      .map(value => zio.aws.s3.model.primitives.ObjectLockToken(value))
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
  ): zio.aws.s3.model.PutObjectLockConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
