package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutObjectLockConfigurationResponse(
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse = {
    import PutObjectLockConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectLockConfigurationResponse.ReadOnly =
    zio.aws.s3.model.PutObjectLockConfigurationResponse.wrap(buildAwsValue())
}
object PutObjectLockConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectLockConfigurationResponse =
      zio.aws.s3.model
        .PutObjectLockConfigurationResponse(requestCharged.map(value => value))
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse
  ) extends zio.aws.s3.model.PutObjectLockConfigurationResponse.ReadOnly {
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse
  ): zio.aws.s3.model.PutObjectLockConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
