package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  ContentType,
  CacheControl,
  ContentMD5,
  WebsiteRedirectLocation,
  GrantRead,
  ContentDisposition,
  ContentLanguage,
  GrantReadACP,
  ContentLength,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  Expires,
  ContentEncoding,
  ObjectKey,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  SSEKMSKeyId,
  MetadataValue,
  TaggingHeader,
  ObjectLockRetainUntilDate,
  MetadataKey,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PutObjectRequest(
    acl: Option[zio.aws.s3.model.ObjectCannedACL] = None,
    bucket: BucketName,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentLength: Option[ContentLength] = None,
    contentMD5: Option[ContentMD5] = None,
    contentType: Option[ContentType] = None,
    expires: Option[Expires] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    key: ObjectKey,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    websiteRedirectLocation: Option[WebsiteRedirectLocation] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    tagging: Option[TaggingHeader] = None,
    objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    objectLockLegalHoldStatus: Option[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectRequest = {
    import PutObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        websiteRedirectLocation.map(value =>
          WebsiteRedirectLocation.unwrap(value): java.lang.String
        )
      )(_.websiteRedirectLocation)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        tagging.map(value => TaggingHeader.unwrap(value): java.lang.String)
      )(_.tagging)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectRequest.ReadOnly =
    zio.aws.s3.model.PutObjectRequest.wrap(buildAwsValue())
}
object PutObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectRequest =
      zio.aws.s3.model.PutObjectRequest(
        acl.map(value => value),
        bucket,
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentLength.map(value => value),
        contentMD5.map(value => value),
        contentType.map(value => value),
        expires.map(value => value),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWriteACP.map(value => value),
        key,
        metadata.map(value => value),
        serverSideEncryption.map(value => value),
        storageClass.map(value => value),
        websiteRedirectLocation.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestPayer.map(value => value),
        tagging.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def acl: Option[zio.aws.s3.model.ObjectCannedACL]
    def bucket: BucketName
    def cacheControl: Option[CacheControl]
    def contentDisposition: Option[ContentDisposition]
    def contentEncoding: Option[ContentEncoding]
    def contentLanguage: Option[ContentLanguage]
    def contentLength: Option[ContentLength]
    def contentMD5: Option[ContentMD5]
    def contentType: Option[ContentType]
    def expires: Option[Expires]
    def grantFullControl: Option[GrantFullControl]
    def grantRead: Option[GrantRead]
    def grantReadACP: Option[GrantReadACP]
    def grantWriteACP: Option[GrantWriteACP]
    def key: ObjectKey
    def metadata: Option[Map[MetadataKey, MetadataValue]]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def websiteRedirectLocation: Option[WebsiteRedirectLocation]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def ssekmsEncryptionContext: Option[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def tagging: Option[TaggingHeader]
    def objectLockMode: Option[zio.aws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def expectedBucketOwner: Option[AccountId]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getWebsiteRedirectLocation
        : ZIO[Any, AwsError, WebsiteRedirectLocation] = AwsError
      .unwrapOptionField("websiteRedirectLocation", websiteRedirectLocation)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getTagging: ZIO[Any, AwsError, TaggingHeader] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRequest
  ) extends zio.aws.s3.model.PutObjectRequest.ReadOnly {
    override val acl: Option[zio.aws.s3.model.ObjectCannedACL] = scala
      .Option(impl.acl())
      .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val cacheControl: Option[CacheControl] = scala
      .Option(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Option[ContentEncoding] = scala
      .Option(impl.contentEncoding())
      .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Option[ContentLanguage] = scala
      .Option(impl.contentLanguage())
      .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentLength: Option[ContentLength] = scala
      .Option(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val expires: Option[Expires] = scala
      .Option(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val grantFullControl: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Option[GrantRead] = scala
      .Option(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Option[GrantReadACP] = scala
      .Option(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWriteACP: Option[GrantWriteACP] = scala
      .Option(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val metadata: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.s3.model.primitives.MetadataKey(
              key
            ) -> zio.aws.s3.model.primitives.MetadataValue(value)
          })
          .toMap
      )
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val websiteRedirectLocation: Option[WebsiteRedirectLocation] =
      scala
        .Option(impl.websiteRedirectLocation())
        .map(value =>
          zio.aws.s3.model.primitives.WebsiteRedirectLocation(value)
        )
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] =
      scala
        .Option(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val tagging: Option[TaggingHeader] = scala
      .Option(impl.tagging())
      .map(value => zio.aws.s3.model.primitives.TaggingHeader(value))
    override val objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] =
      scala
        .Option(impl.objectLockRetainUntilDate())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
        )
    override val objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus] = scala
      .Option(impl.objectLockLegalHoldStatus())
      .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRequest
  ): zio.aws.s3.model.PutObjectRequest.ReadOnly = new Wrapper(impl)
}
