package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  BypassGovernanceRetention,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutObjectRetentionRequest(
    bucket: BucketName,
    key: ObjectKey,
    retention: Option[zio.aws.s3.model.ObjectLockRetention] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    versionId: Option[ObjectVersionId] = None,
    bypassGovernanceRetention: Option[BypassGovernanceRetention] = None,
    contentMD5: Option[ContentMD5] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest = {
    import PutObjectRetentionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(retention.map(value => value.buildAwsValue()))(
        _.retention
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        bypassGovernanceRetention.map(value =>
          BypassGovernanceRetention.unwrap(value): java.lang.Boolean
        )
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectRetentionRequest.ReadOnly =
    zio.aws.s3.model.PutObjectRetentionRequest.wrap(buildAwsValue())
}
object PutObjectRetentionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectRetentionRequest =
      zio.aws.s3.model.PutObjectRetentionRequest(
        bucket,
        key,
        retention.map(value => value.asEditable),
        requestPayer.map(value => value),
        versionId.map(value => value),
        bypassGovernanceRetention.map(value => value),
        contentMD5.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def retention: Option[zio.aws.s3.model.ObjectLockRetention.ReadOnly]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def versionId: Option[ObjectVersionId]
    def bypassGovernanceRetention: Option[BypassGovernanceRetention]
    def contentMD5: Option[ContentMD5]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getRetention
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockRetention.ReadOnly] =
      AwsError.unwrapOptionField("retention", retention)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getBypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ) extends zio.aws.s3.model.PutObjectRetentionRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val retention
        : Option[zio.aws.s3.model.ObjectLockRetention.ReadOnly] = scala
      .Option(impl.retention())
      .map(value => zio.aws.s3.model.ObjectLockRetention.wrap(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val bypassGovernanceRetention: Option[BypassGovernanceRetention] =
      scala
        .Option(impl.bypassGovernanceRetention())
        .map(value =>
          zio.aws.s3.model.primitives.BypassGovernanceRetention(value)
        )
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ): zio.aws.s3.model.PutObjectRetentionRequest.ReadOnly = new Wrapper(impl)
}
