package zio.aws.s3.model
import zio.aws.s3.model.primitives.{QueueArn, NotificationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueueConfiguration(
    id: Option[NotificationId] = None,
    queueArn: QueueArn,
    events: Iterable[zio.aws.s3.model.Event],
    filter: Option[zio.aws.s3.model.NotificationConfigurationFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.QueueConfiguration = {
    import QueueConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.QueueConfiguration
      .builder()
      .optionallyWith(
        id.map(value => NotificationId.unwrap(value): java.lang.String)
      )(_.id)
      .queueArn(QueueArn.unwrap(queueArn): java.lang.String)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.QueueConfiguration.ReadOnly =
    zio.aws.s3.model.QueueConfiguration.wrap(buildAwsValue())
}
object QueueConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.QueueConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.QueueConfiguration =
      zio.aws.s3.model.QueueConfiguration(
        id.map(value => value),
        queueArn,
        events,
        filter.map(value => value.asEditable)
      )
    def id: Option[NotificationId]
    def queueArn: QueueArn
    def events: List[zio.aws.s3.model.Event]
    def filter
        : Option[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly]
    def getId: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", id)
    def getQueueArn: ZIO[Any, Nothing, QueueArn] = ZIO.succeed(queueArn)
    def getEvents: ZIO[Any, Nothing, List[zio.aws.s3.model.Event]] =
      ZIO.succeed(events)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.QueueConfiguration
  ) extends zio.aws.s3.model.QueueConfiguration.ReadOnly {
    override val id: Option[NotificationId] = scala
      .Option(impl.id())
      .map(value => zio.aws.s3.model.primitives.NotificationId(value))
    override val queueArn: QueueArn =
      zio.aws.s3.model.primitives.QueueArn(impl.queueArn())
    override val events: List[zio.aws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.s3.model.Event.wrap(item)
      }
      .toList
    override val filter
        : Option[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value =>
          zio.aws.s3.model.NotificationConfigurationFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.QueueConfiguration
  ): zio.aws.s3.model.QueueConfiguration.ReadOnly = new Wrapper(impl)
}
