package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ReplaceKeyWith,
  ReplaceKeyPrefixWith,
  HttpRedirectCode,
  HostName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Redirect(
    hostName: Option[HostName] = None,
    httpRedirectCode: Option[HttpRedirectCode] = None,
    protocol: Option[zio.aws.s3.model.Protocol] = None,
    replaceKeyPrefixWith: Option[ReplaceKeyPrefixWith] = None,
    replaceKeyWith: Option[ReplaceKeyWith] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Redirect = {
    import Redirect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Redirect
      .builder()
      .optionallyWith(
        hostName.map(value => HostName.unwrap(value): java.lang.String)
      )(_.hostName)
      .optionallyWith(
        httpRedirectCode.map(value =>
          HttpRedirectCode.unwrap(value): java.lang.String
        )
      )(_.httpRedirectCode)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        replaceKeyPrefixWith.map(value =>
          ReplaceKeyPrefixWith.unwrap(value): java.lang.String
        )
      )(_.replaceKeyPrefixWith)
      .optionallyWith(
        replaceKeyWith.map(value =>
          ReplaceKeyWith.unwrap(value): java.lang.String
        )
      )(_.replaceKeyWith)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Redirect.ReadOnly =
    zio.aws.s3.model.Redirect.wrap(buildAwsValue())
}
object Redirect {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Redirect] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Redirect = zio.aws.s3.model.Redirect(
      hostName.map(value => value),
      httpRedirectCode.map(value => value),
      protocol.map(value => value),
      replaceKeyPrefixWith.map(value => value),
      replaceKeyWith.map(value => value)
    )
    def hostName: Option[HostName]
    def httpRedirectCode: Option[HttpRedirectCode]
    def protocol: Option[zio.aws.s3.model.Protocol]
    def replaceKeyPrefixWith: Option[ReplaceKeyPrefixWith]
    def replaceKeyWith: Option[ReplaceKeyWith]
    def getHostName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getHttpRedirectCode: ZIO[Any, AwsError, HttpRedirectCode] =
      AwsError.unwrapOptionField("httpRedirectCode", httpRedirectCode)
    def getProtocol: ZIO[Any, AwsError, zio.aws.s3.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getReplaceKeyPrefixWith: ZIO[Any, AwsError, ReplaceKeyPrefixWith] =
      AwsError.unwrapOptionField("replaceKeyPrefixWith", replaceKeyPrefixWith)
    def getReplaceKeyWith: ZIO[Any, AwsError, ReplaceKeyWith] =
      AwsError.unwrapOptionField("replaceKeyWith", replaceKeyWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Redirect
  ) extends zio.aws.s3.model.Redirect.ReadOnly {
    override val hostName: Option[HostName] = scala
      .Option(impl.hostName())
      .map(value => zio.aws.s3.model.primitives.HostName(value))
    override val httpRedirectCode: Option[HttpRedirectCode] = scala
      .Option(impl.httpRedirectCode())
      .map(value => zio.aws.s3.model.primitives.HttpRedirectCode(value))
    override val protocol: Option[zio.aws.s3.model.Protocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.s3.model.Protocol.wrap(value))
    override val replaceKeyPrefixWith: Option[ReplaceKeyPrefixWith] = scala
      .Option(impl.replaceKeyPrefixWith())
      .map(value => zio.aws.s3.model.primitives.ReplaceKeyPrefixWith(value))
    override val replaceKeyWith: Option[ReplaceKeyWith] = scala
      .Option(impl.replaceKeyWith())
      .map(value => zio.aws.s3.model.primitives.ReplaceKeyWith(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Redirect
  ): zio.aws.s3.model.Redirect.ReadOnly = new Wrapper(impl)
}
