package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{Prefix, Priority, ID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReplicationRule(
    id: Option[ID] = None,
    priority: Option[Priority] = None,
    prefix: Option[Prefix] = None,
    filter: Option[zio.aws.s3.model.ReplicationRuleFilter] = None,
    status: zio.aws.s3.model.ReplicationRuleStatus,
    sourceSelectionCriteria: Option[zio.aws.s3.model.SourceSelectionCriteria] =
      None,
    existingObjectReplication: Option[
      zio.aws.s3.model.ExistingObjectReplication
    ] = None,
    destination: zio.aws.s3.model.Destination,
    deleteMarkerReplication: Option[zio.aws.s3.model.DeleteMarkerReplication] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicationRule = {
    import ReplicationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicationRule
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        sourceSelectionCriteria.map(value => value.buildAwsValue())
      )(_.sourceSelectionCriteria)
      .optionallyWith(
        existingObjectReplication.map(value => value.buildAwsValue())
      )(_.existingObjectReplication)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        deleteMarkerReplication.map(value => value.buildAwsValue())
      )(_.deleteMarkerReplication)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ReplicationRule.ReadOnly =
    zio.aws.s3.model.ReplicationRule.wrap(buildAwsValue())
}
object ReplicationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ReplicationRule =
      zio.aws.s3.model.ReplicationRule(
        id.map(value => value),
        priority.map(value => value),
        prefix.map(value => value),
        filter.map(value => value.asEditable),
        status,
        sourceSelectionCriteria.map(value => value.asEditable),
        existingObjectReplication.map(value => value.asEditable),
        destination.asEditable,
        deleteMarkerReplication.map(value => value.asEditable)
      )
    def id: Option[ID]
    def priority: Option[Priority]
    def prefix: Option[Prefix]
    def filter: Option[zio.aws.s3.model.ReplicationRuleFilter.ReadOnly]
    def status: zio.aws.s3.model.ReplicationRuleStatus
    def sourceSelectionCriteria
        : Option[zio.aws.s3.model.SourceSelectionCriteria.ReadOnly]
    def existingObjectReplication
        : Option[zio.aws.s3.model.ExistingObjectReplication.ReadOnly]
    def destination: zio.aws.s3.model.Destination.ReadOnly
    def deleteMarkerReplication
        : Option[zio.aws.s3.model.DeleteMarkerReplication.ReadOnly]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationRuleFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getStatus: ZIO[Any, Nothing, zio.aws.s3.model.ReplicationRuleStatus] =
      ZIO.succeed(status)
    def getSourceSelectionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.SourceSelectionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceSelectionCriteria",
      sourceSelectionCriteria
    )
    def getExistingObjectReplication: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.ExistingObjectReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "existingObjectReplication",
      existingObjectReplication
    )
    def getDestination
        : ZIO[Any, Nothing, zio.aws.s3.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getDeleteMarkerReplication: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.DeleteMarkerReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteMarkerReplication",
      deleteMarkerReplication
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicationRule
  ) extends zio.aws.s3.model.ReplicationRule.ReadOnly {
    override val id: Option[ID] = scala
      .Option(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
    override val priority: Option[Priority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.s3.model.primitives.Priority(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val filter
        : Option[zio.aws.s3.model.ReplicationRuleFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.s3.model.ReplicationRuleFilter.wrap(value))
    override val status: zio.aws.s3.model.ReplicationRuleStatus =
      zio.aws.s3.model.ReplicationRuleStatus.wrap(impl.status())
    override val sourceSelectionCriteria
        : Option[zio.aws.s3.model.SourceSelectionCriteria.ReadOnly] = scala
      .Option(impl.sourceSelectionCriteria())
      .map(value => zio.aws.s3.model.SourceSelectionCriteria.wrap(value))
    override val existingObjectReplication
        : Option[zio.aws.s3.model.ExistingObjectReplication.ReadOnly] = scala
      .Option(impl.existingObjectReplication())
      .map(value => zio.aws.s3.model.ExistingObjectReplication.wrap(value))
    override val destination: zio.aws.s3.model.Destination.ReadOnly =
      zio.aws.s3.model.Destination.wrap(impl.destination())
    override val deleteMarkerReplication
        : Option[zio.aws.s3.model.DeleteMarkerReplication.ReadOnly] = scala
      .Option(impl.deleteMarkerReplication())
      .map(value => zio.aws.s3.model.DeleteMarkerReplication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicationRule
  ): zio.aws.s3.model.ReplicationRule.ReadOnly = new Wrapper(impl)
}
