package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  ObjectVersionId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreObjectRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None,
    restoreRequest: Option[zio.aws.s3.model.RestoreRequest] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreObjectRequest = {
    import RestoreObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreObjectRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(restoreRequest.map(value => value.buildAwsValue()))(
        _.restoreRequest
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RestoreObjectRequest.ReadOnly =
    zio.aws.s3.model.RestoreObjectRequest.wrap(buildAwsValue())
}
object RestoreObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RestoreObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RestoreObjectRequest =
      zio.aws.s3.model.RestoreObjectRequest(
        bucket,
        key,
        versionId.map(value => value),
        restoreRequest.map(value => value.asEditable),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def versionId: Option[ObjectVersionId]
    def restoreRequest: Option[zio.aws.s3.model.RestoreRequest.ReadOnly]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getRestoreRequest
        : ZIO[Any, AwsError, zio.aws.s3.model.RestoreRequest.ReadOnly] =
      AwsError.unwrapOptionField("restoreRequest", restoreRequest)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectRequest
  ) extends zio.aws.s3.model.RestoreObjectRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val restoreRequest
        : Option[zio.aws.s3.model.RestoreRequest.ReadOnly] = scala
      .Option(impl.restoreRequest())
      .map(value => zio.aws.s3.model.RestoreRequest.wrap(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectRequest
  ): zio.aws.s3.model.RestoreObjectRequest.ReadOnly = new Wrapper(impl)
}
