package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RoutingRule(
    condition: Option[zio.aws.s3.model.Condition] = None,
    redirect: zio.aws.s3.model.Redirect
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.RoutingRule = {
    import RoutingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RoutingRule
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .redirect(redirect.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RoutingRule.ReadOnly =
    zio.aws.s3.model.RoutingRule.wrap(buildAwsValue())
}
object RoutingRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RoutingRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RoutingRule = zio.aws.s3.model.RoutingRule(
      condition.map(value => value.asEditable),
      redirect.asEditable
    )
    def condition: Option[zio.aws.s3.model.Condition.ReadOnly]
    def redirect: zio.aws.s3.model.Redirect.ReadOnly
    def getCondition: ZIO[Any, AwsError, zio.aws.s3.model.Condition.ReadOnly] =
      AwsError.unwrapOptionField("condition", condition)
    def getRedirect: ZIO[Any, Nothing, zio.aws.s3.model.Redirect.ReadOnly] =
      ZIO.succeed(redirect)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RoutingRule
  ) extends zio.aws.s3.model.RoutingRule.ReadOnly {
    override val condition: Option[zio.aws.s3.model.Condition.ReadOnly] = scala
      .Option(impl.condition())
      .map(value => zio.aws.s3.model.Condition.wrap(value))
    override val redirect: zio.aws.s3.model.Redirect.ReadOnly =
      zio.aws.s3.model.Redirect.wrap(impl.redirect())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RoutingRule
  ): zio.aws.s3.model.RoutingRule.ReadOnly = new Wrapper(impl)
}
