package zio.aws.s3.model
import zio.aws.s3.model.primitives.{ETag, LastModified, ObjectKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class S3Object(
    key: Option[ObjectKey] = None,
    lastModified: Option[LastModified] = None,
    eTag: Option[ETag] = None,
    size: Option[Long] = None,
    storageClass: Option[zio.aws.s3.model.ObjectStorageClass] = None,
    owner: Option[zio.aws.s3.model.Owner] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Object
      .builder()
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.S3Object.ReadOnly =
    zio.aws.s3.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Object] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.S3Object = zio.aws.s3.model.S3Object(
      key.map(value => value),
      lastModified.map(value => value),
      eTag.map(value => value),
      size.map(value => value),
      storageClass.map(value => value),
      owner.map(value => value.asEditable)
    )
    def key: Option[ObjectKey]
    def lastModified: Option[LastModified]
    def eTag: Option[ETag]
    def size: Option[Long]
    def storageClass: Option[zio.aws.s3.model.ObjectStorageClass]
    def owner: Option[zio.aws.s3.model.Owner.ReadOnly]
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3Object
  ) extends zio.aws.s3.model.S3Object.ReadOnly {
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val size: Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
    override val storageClass: Option[zio.aws.s3.model.ObjectStorageClass] =
      scala
        .Option(impl.storageClass())
        .map(value => zio.aws.s3.model.ObjectStorageClass.wrap(value))
    override val owner: Option[zio.aws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => zio.aws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Object
  ): zio.aws.s3.model.S3Object.ReadOnly = new Wrapper(impl)
}
