package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SseKmsEncryptedObjects(
    status: zio.aws.s3.model.SseKmsEncryptedObjectsStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects = {
    import SseKmsEncryptedObjects.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.SseKmsEncryptedObjects.ReadOnly =
    zio.aws.s3.model.SseKmsEncryptedObjects.wrap(buildAwsValue())
}
object SseKmsEncryptedObjects {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.SseKmsEncryptedObjects =
      zio.aws.s3.model.SseKmsEncryptedObjects(status)
    def status: zio.aws.s3.model.SseKmsEncryptedObjectsStatus
    def getStatus
        : ZIO[Any, Nothing, zio.aws.s3.model.SseKmsEncryptedObjectsStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
  ) extends zio.aws.s3.model.SseKmsEncryptedObjects.ReadOnly {
    override val status: zio.aws.s3.model.SseKmsEncryptedObjectsStatus =
      zio.aws.s3.model.SseKmsEncryptedObjectsStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
  ): zio.aws.s3.model.SseKmsEncryptedObjects.ReadOnly = new Wrapper(impl)
}
