package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait Tier { def unwrap: software.amazon.awssdk.services.s3.model.Tier }
object Tier {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.Tier
  ): zio.aws.s3.model.Tier = value match {
    case software.amazon.awssdk.services.s3.model.Tier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.Tier.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.s3.model.Tier.BULK =>
      val r = Bulk
      r
    case software.amazon.awssdk.services.s3.model.Tier.EXPEDITED =>
      val r = Expedited
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.Tier {
    override def unwrap: software.amazon.awssdk.services.s3.model.Tier =
      software.amazon.awssdk.services.s3.model.Tier.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.s3.model.Tier {
    override def unwrap: software.amazon.awssdk.services.s3.model.Tier =
      software.amazon.awssdk.services.s3.model.Tier.STANDARD
  }
  case object Bulk extends zio.aws.s3.model.Tier {
    override def unwrap: software.amazon.awssdk.services.s3.model.Tier =
      software.amazon.awssdk.services.s3.model.Tier.BULK
  }
  case object Expedited extends zio.aws.s3.model.Tier {
    override def unwrap: software.amazon.awssdk.services.s3.model.Tier =
      software.amazon.awssdk.services.s3.model.Tier.EXPEDITED
  }
}
