package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  CopySourceSSECustomerKeyMD5,
  CopySourceSSECustomerAlgorithm,
  AccountId,
  CopySourceRange,
  SSECustomerAlgorithm,
  CopySourceIfUnmodifiedSince,
  SSECustomerKeyMD5,
  CopySourceIfMatch,
  ObjectKey,
  BucketName,
  CopySourceSSECustomerKey,
  CopySourceIfNoneMatch,
  CopySourceIfModifiedSince,
  PartNumber,
  CopySource,
  MultipartUploadId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UploadPartCopyRequest(
    destinationBucket: BucketName,
    copySource: CopySource,
    copySourceIfMatch: Option[CopySourceIfMatch] = None,
    copySourceIfModifiedSince: Option[CopySourceIfModifiedSince] = None,
    copySourceIfNoneMatch: Option[CopySourceIfNoneMatch] = None,
    copySourceIfUnmodifiedSince: Option[CopySourceIfUnmodifiedSince] = None,
    copySourceRange: Option[CopySourceRange] = None,
    destinationKey: ObjectKey,
    partNumber: PartNumber,
    uploadId: MultipartUploadId,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    copySourceSSECustomerAlgorithm: Option[CopySourceSSECustomerAlgorithm] =
      None,
    copySourceSSECustomerKey: Option[CopySourceSSECustomerKey] = None,
    copySourceSSECustomerKeyMD5: Option[CopySourceSSECustomerKeyMD5] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None,
    expectedSourceBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartCopyRequest = {
    import UploadPartCopyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
      .builder()
      .destinationBucket(BucketName.unwrap(destinationBucket): java.lang.String)
      .copySource(CopySource.unwrap(copySource): java.lang.String)
      .optionallyWith(
        copySourceIfMatch.map(value =>
          CopySourceIfMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfMatch)
      .optionallyWith(
        copySourceIfModifiedSince.map(value =>
          CopySourceIfModifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfModifiedSince)
      .optionallyWith(
        copySourceIfNoneMatch.map(value =>
          CopySourceIfNoneMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfNoneMatch)
      .optionallyWith(
        copySourceIfUnmodifiedSince.map(value =>
          CopySourceIfUnmodifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfUnmodifiedSince)
      .optionallyWith(
        copySourceRange.map(value =>
          CopySourceRange.unwrap(value): java.lang.String
        )
      )(_.copySourceRange)
      .destinationKey(ObjectKey.unwrap(destinationKey): java.lang.String)
      .partNumber(PartNumber.unwrap(partNumber): Integer)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        copySourceSSECustomerAlgorithm.map(value =>
          CopySourceSSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerAlgorithm)
      .optionallyWith(
        copySourceSSECustomerKey.map(value =>
          CopySourceSSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKey)
      .optionallyWith(
        copySourceSSECustomerKeyMD5.map(value =>
          CopySourceSSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        expectedSourceBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedSourceBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.UploadPartCopyRequest.ReadOnly =
    zio.aws.s3.model.UploadPartCopyRequest.wrap(buildAwsValue())
}
object UploadPartCopyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.UploadPartCopyRequest =
      zio.aws.s3.model.UploadPartCopyRequest(
        destinationBucket,
        copySource,
        copySourceIfMatch.map(value => value),
        copySourceIfModifiedSince.map(value => value),
        copySourceIfNoneMatch.map(value => value),
        copySourceIfUnmodifiedSince.map(value => value),
        copySourceRange.map(value => value),
        destinationKey,
        partNumber,
        uploadId,
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        copySourceSSECustomerAlgorithm.map(value => value),
        copySourceSSECustomerKey.map(value => value),
        copySourceSSECustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value),
        expectedSourceBucketOwner.map(value => value)
      )
    def destinationBucket: BucketName
    def copySource: CopySource
    def copySourceIfMatch: Option[CopySourceIfMatch]
    def copySourceIfModifiedSince: Option[CopySourceIfModifiedSince]
    def copySourceIfNoneMatch: Option[CopySourceIfNoneMatch]
    def copySourceIfUnmodifiedSince: Option[CopySourceIfUnmodifiedSince]
    def copySourceRange: Option[CopySourceRange]
    def destinationKey: ObjectKey
    def partNumber: PartNumber
    def uploadId: MultipartUploadId
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def copySourceSSECustomerAlgorithm: Option[CopySourceSSECustomerAlgorithm]
    def copySourceSSECustomerKey: Option[CopySourceSSECustomerKey]
    def copySourceSSECustomerKeyMD5: Option[CopySourceSSECustomerKeyMD5]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def expectedSourceBucketOwner: Option[AccountId]
    def getDestinationBucket: ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(destinationBucket)
    def getCopySource: ZIO[Any, Nothing, CopySource] = ZIO.succeed(copySource)
    def getCopySourceIfMatch: ZIO[Any, AwsError, CopySourceIfMatch] =
      AwsError.unwrapOptionField("copySourceIfMatch", copySourceIfMatch)
    def getCopySourceIfModifiedSince
        : ZIO[Any, AwsError, CopySourceIfModifiedSince] = AwsError
      .unwrapOptionField("copySourceIfModifiedSince", copySourceIfModifiedSince)
    def getCopySourceIfNoneMatch: ZIO[Any, AwsError, CopySourceIfNoneMatch] =
      AwsError.unwrapOptionField("copySourceIfNoneMatch", copySourceIfNoneMatch)
    def getCopySourceIfUnmodifiedSince
        : ZIO[Any, AwsError, CopySourceIfUnmodifiedSince] =
      AwsError.unwrapOptionField(
        "copySourceIfUnmodifiedSince",
        copySourceIfUnmodifiedSince
      )
    def getCopySourceRange: ZIO[Any, AwsError, CopySourceRange] =
      AwsError.unwrapOptionField("copySourceRange", copySourceRange)
    def getDestinationKey: ZIO[Any, Nothing, ObjectKey] =
      ZIO.succeed(destinationKey)
    def getPartNumber: ZIO[Any, Nothing, PartNumber] = ZIO.succeed(partNumber)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getCopySourceSSECustomerAlgorithm
        : ZIO[Any, AwsError, CopySourceSSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerAlgorithm",
        copySourceSSECustomerAlgorithm
      )
    def getCopySourceSSECustomerKey
        : ZIO[Any, AwsError, CopySourceSSECustomerKey] = AwsError
      .unwrapOptionField("copySourceSSECustomerKey", copySourceSSECustomerKey)
    def getCopySourceSSECustomerKeyMD5
        : ZIO[Any, AwsError, CopySourceSSECustomerKeyMD5] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerKeyMD5",
        copySourceSSECustomerKeyMD5
      )
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getExpectedSourceBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedSourceBucketOwner", expectedSourceBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ) extends zio.aws.s3.model.UploadPartCopyRequest.ReadOnly {
    override val destinationBucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.destinationBucket())
    override val copySource: CopySource =
      zio.aws.s3.model.primitives.CopySource(impl.copySource())
    override val copySourceIfMatch: Option[CopySourceIfMatch] = scala
      .Option(impl.copySourceIfMatch())
      .map(value => zio.aws.s3.model.primitives.CopySourceIfMatch(value))
    override val copySourceIfModifiedSince: Option[CopySourceIfModifiedSince] =
      scala
        .Option(impl.copySourceIfModifiedSince())
        .map(value =>
          zio.aws.s3.model.primitives.CopySourceIfModifiedSince(value)
        )
    override val copySourceIfNoneMatch: Option[CopySourceIfNoneMatch] = scala
      .Option(impl.copySourceIfNoneMatch())
      .map(value => zio.aws.s3.model.primitives.CopySourceIfNoneMatch(value))
    override val copySourceIfUnmodifiedSince
        : Option[CopySourceIfUnmodifiedSince] = scala
      .Option(impl.copySourceIfUnmodifiedSince())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceIfUnmodifiedSince(value)
      )
    override val copySourceRange: Option[CopySourceRange] = scala
      .Option(impl.copySourceRange())
      .map(value => zio.aws.s3.model.primitives.CopySourceRange(value))
    override val destinationKey: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.destinationKey())
    override val partNumber: PartNumber =
      zio.aws.s3.model.primitives.PartNumber(impl.partNumber())
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val copySourceSSECustomerAlgorithm
        : Option[CopySourceSSECustomerAlgorithm] = scala
      .Option(impl.copySourceSSECustomerAlgorithm())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerAlgorithm(value)
      )
    override val copySourceSSECustomerKey: Option[CopySourceSSECustomerKey] =
      scala
        .Option(impl.copySourceSSECustomerKey())
        .map(value =>
          zio.aws.s3.model.primitives.CopySourceSSECustomerKey(value)
        )
    override val copySourceSSECustomerKeyMD5
        : Option[CopySourceSSECustomerKeyMD5] = scala
      .Option(impl.copySourceSSECustomerKeyMD5())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerKeyMD5(value)
      )
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val expectedSourceBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedSourceBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ): zio.aws.s3.model.UploadPartCopyRequest.ReadOnly = new Wrapper(impl)
}
