package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSKeyId,
  CopySourceVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UploadPartCopyResponse(
    copySourceVersionId: Option[CopySourceVersionId] = None,
    copyPartResult: Option[zio.aws.s3.model.CopyPartResult] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartCopyResponse = {
    import UploadPartCopyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
      .builder()
      .optionallyWith(
        copySourceVersionId.map(value =>
          CopySourceVersionId.unwrap(value): java.lang.String
        )
      )(_.copySourceVersionId)
      .optionallyWith(copyPartResult.map(value => value.buildAwsValue()))(
        _.copyPartResult
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.UploadPartCopyResponse.ReadOnly =
    zio.aws.s3.model.UploadPartCopyResponse.wrap(buildAwsValue())
}
object UploadPartCopyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.UploadPartCopyResponse =
      zio.aws.s3.model.UploadPartCopyResponse(
        copySourceVersionId.map(value => value),
        copyPartResult.map(value => value.asEditable),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value)
      )
    def copySourceVersionId: Option[CopySourceVersionId]
    def copyPartResult: Option[zio.aws.s3.model.CopyPartResult.ReadOnly]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def getCopySourceVersionId: ZIO[Any, AwsError, CopySourceVersionId] =
      AwsError.unwrapOptionField("copySourceVersionId", copySourceVersionId)
    def getCopyPartResult
        : ZIO[Any, AwsError, zio.aws.s3.model.CopyPartResult.ReadOnly] =
      AwsError.unwrapOptionField("copyPartResult", copyPartResult)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ) extends zio.aws.s3.model.UploadPartCopyResponse.ReadOnly {
    override val copySourceVersionId: Option[CopySourceVersionId] = scala
      .Option(impl.copySourceVersionId())
      .map(value => zio.aws.s3.model.primitives.CopySourceVersionId(value))
    override val copyPartResult
        : Option[zio.aws.s3.model.CopyPartResult.ReadOnly] = scala
      .Option(impl.copyPartResult())
      .map(value => zio.aws.s3.model.CopyPartResult.wrap(value))
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ): zio.aws.s3.model.UploadPartCopyResponse.ReadOnly = new Wrapper(impl)
}
