package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  ContentMD5,
  ContentLength,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ObjectKey,
  BucketName,
  PartNumber,
  MultipartUploadId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UploadPartRequest(
    bucket: BucketName,
    contentLength: Option[ContentLength] = None,
    contentMD5: Option[ContentMD5] = None,
    key: ObjectKey,
    partNumber: PartNumber,
    uploadId: MultipartUploadId,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartRequest = {
    import UploadPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .partNumber(PartNumber.unwrap(partNumber): Integer)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.UploadPartRequest.ReadOnly =
    zio.aws.s3.model.UploadPartRequest.wrap(buildAwsValue())
}
object UploadPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.UploadPartRequest =
      zio.aws.s3.model.UploadPartRequest(
        bucket,
        contentLength.map(value => value),
        contentMD5.map(value => value),
        key,
        partNumber,
        uploadId,
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentLength: Option[ContentLength]
    def contentMD5: Option[ContentMD5]
    def key: ObjectKey
    def partNumber: PartNumber
    def uploadId: MultipartUploadId
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getPartNumber: ZIO[Any, Nothing, PartNumber] = ZIO.succeed(partNumber)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartRequest
  ) extends zio.aws.s3.model.UploadPartRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentLength: Option[ContentLength] = scala
      .Option(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val partNumber: PartNumber =
      zio.aws.s3.model.primitives.PartNumber(impl.partNumber())
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartRequest
  ): zio.aws.s3.model.UploadPartRequest.ReadOnly = new Wrapper(impl)
}
