package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VersioningConfiguration(
    mfaDelete: Option[zio.aws.s3.model.MFADelete] = None,
    status: Option[zio.aws.s3.model.BucketVersioningStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.VersioningConfiguration = {
    import VersioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.VersioningConfiguration
      .builder()
      .optionallyWith(mfaDelete.map(value => value.unwrap))(_.mfaDelete)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.VersioningConfiguration.ReadOnly =
    zio.aws.s3.model.VersioningConfiguration.wrap(buildAwsValue())
}
object VersioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.VersioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.VersioningConfiguration =
      zio.aws.s3.model.VersioningConfiguration(
        mfaDelete.map(value => value),
        status.map(value => value)
      )
    def mfaDelete: Option[zio.aws.s3.model.MFADelete]
    def status: Option[zio.aws.s3.model.BucketVersioningStatus]
    def getMfaDelete: ZIO[Any, AwsError, zio.aws.s3.model.MFADelete] =
      AwsError.unwrapOptionField("mfaDelete", mfaDelete)
    def getStatus: ZIO[Any, AwsError, zio.aws.s3.model.BucketVersioningStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.VersioningConfiguration
  ) extends zio.aws.s3.model.VersioningConfiguration.ReadOnly {
    override val mfaDelete: Option[zio.aws.s3.model.MFADelete] = scala
      .Option(impl.mfaDelete())
      .map(value => zio.aws.s3.model.MFADelete.wrap(value))
    override val status: Option[zio.aws.s3.model.BucketVersioningStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3.model.BucketVersioningStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.VersioningConfiguration
  ): zio.aws.s3.model.VersioningConfiguration.ReadOnly = new Wrapper(impl)
}
