package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ContentType,
  ErrorMessage,
  ETag,
  CacheControl,
  GetObjectResponseStatusCode,
  TagCount,
  AcceptRanges,
  ContentDisposition,
  ContentLanguage,
  Expiration,
  ContentLength,
  PartsCount,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  DeleteMarker,
  LastModified,
  Expires,
  ContentEncoding,
  ErrorCode,
  RequestToken,
  MissingMeta,
  SSEKMSKeyId,
  MetadataValue,
  RequestRoute,
  ObjectLockRetainUntilDate,
  Restore,
  ObjectVersionId,
  MetadataKey,
  BucketKeyEnabled,
  ContentRange
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WriteGetObjectResponseRequest(
    requestRoute: RequestRoute,
    requestToken: RequestToken,
    statusCode: Option[GetObjectResponseStatusCode] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None,
    acceptRanges: Option[AcceptRanges] = None,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentLength: Option[ContentLength] = None,
    contentRange: Option[ContentRange] = None,
    contentType: Option[ContentType] = None,
    deleteMarker: Option[DeleteMarker] = None,
    eTag: Option[ETag] = None,
    expires: Option[Expires] = None,
    expiration: Option[Expiration] = None,
    lastModified: Option[LastModified] = None,
    missingMeta: Option[MissingMeta] = None,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = None,
    objectLockLegalHoldStatus: Option[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    partsCount: Option[PartsCount] = None,
    replicationStatus: Option[zio.aws.s3.model.ReplicationStatus] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None,
    restore: Option[Restore] = None,
    serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    tagCount: Option[TagCount] = None,
    versionId: Option[ObjectVersionId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest = {
    import WriteGetObjectResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
      .builder()
      .requestRoute(RequestRoute.unwrap(requestRoute): java.lang.String)
      .requestToken(RequestToken.unwrap(requestToken): java.lang.String)
      .optionallyWith(
        statusCode.map(value =>
          GetObjectResponseStatusCode.unwrap(value): Integer
        )
      )(_.statusCode)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        acceptRanges.map(value => AcceptRanges.unwrap(value): java.lang.String)
      )(_.acceptRanges)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        contentRange.map(value => ContentRange.unwrap(value): java.lang.String)
      )(_.contentRange)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        missingMeta.map(value => MissingMeta.unwrap(value): Integer)
      )(_.missingMeta)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(
        partsCount.map(value => PartsCount.unwrap(value): Integer)
      )(_.partsCount)
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(
        restore.map(value => Restore.unwrap(value): java.lang.String)
      )(_.restore)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(tagCount.map(value => TagCount.unwrap(value): Integer))(
        _.tagCount
      )
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.WriteGetObjectResponseRequest.ReadOnly =
    zio.aws.s3.model.WriteGetObjectResponseRequest.wrap(buildAwsValue())
}
object WriteGetObjectResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.WriteGetObjectResponseRequest =
      zio.aws.s3.model.WriteGetObjectResponseRequest(
        requestRoute,
        requestToken,
        statusCode.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        acceptRanges.map(value => value),
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentLength.map(value => value),
        contentRange.map(value => value),
        contentType.map(value => value),
        deleteMarker.map(value => value),
        eTag.map(value => value),
        expires.map(value => value),
        expiration.map(value => value),
        lastModified.map(value => value),
        missingMeta.map(value => value),
        metadata.map(value => value),
        objectLockMode.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        partsCount.map(value => value),
        replicationStatus.map(value => value),
        requestCharged.map(value => value),
        restore.map(value => value),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        ssekmsKeyId.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        storageClass.map(value => value),
        tagCount.map(value => value),
        versionId.map(value => value),
        bucketKeyEnabled.map(value => value)
      )
    def requestRoute: RequestRoute
    def requestToken: RequestToken
    def statusCode: Option[GetObjectResponseStatusCode]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def acceptRanges: Option[AcceptRanges]
    def cacheControl: Option[CacheControl]
    def contentDisposition: Option[ContentDisposition]
    def contentEncoding: Option[ContentEncoding]
    def contentLanguage: Option[ContentLanguage]
    def contentLength: Option[ContentLength]
    def contentRange: Option[ContentRange]
    def contentType: Option[ContentType]
    def deleteMarker: Option[DeleteMarker]
    def eTag: Option[ETag]
    def expires: Option[Expires]
    def expiration: Option[Expiration]
    def lastModified: Option[LastModified]
    def missingMeta: Option[MissingMeta]
    def metadata: Option[Map[MetadataKey, MetadataValue]]
    def objectLockMode: Option[zio.aws.s3.model.ObjectLockMode]
    def objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate]
    def partsCount: Option[PartsCount]
    def replicationStatus: Option[zio.aws.s3.model.ReplicationStatus]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def restore: Option[Restore]
    def serverSideEncryption: Option[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def ssekmsKeyId: Option[SSEKMSKeyId]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def tagCount: Option[TagCount]
    def versionId: Option[ObjectVersionId]
    def bucketKeyEnabled: Option[BucketKeyEnabled]
    def getRequestRoute: ZIO[Any, Nothing, RequestRoute] =
      ZIO.succeed(requestRoute)
    def getRequestToken: ZIO[Any, Nothing, RequestToken] =
      ZIO.succeed(requestToken)
    def getStatusCode: ZIO[Any, AwsError, GetObjectResponseStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getAcceptRanges: ZIO[Any, AwsError, AcceptRanges] =
      AwsError.unwrapOptionField("acceptRanges", acceptRanges)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentRange: ZIO[Any, AwsError, ContentRange] =
      AwsError.unwrapOptionField("contentRange", contentRange)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getMissingMeta: ZIO[Any, AwsError, MissingMeta] =
      AwsError.unwrapOptionField("missingMeta", missingMeta)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("partsCount", partsCount)
    def getReplicationStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationStatus] =
      AwsError.unwrapOptionField("replicationStatus", replicationStatus)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getRestore: ZIO[Any, AwsError, Restore] =
      AwsError.unwrapOptionField("restore", restore)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getTagCount: ZIO[Any, AwsError, TagCount] =
      AwsError.unwrapOptionField("tagCount", tagCount)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ) extends zio.aws.s3.model.WriteGetObjectResponseRequest.ReadOnly {
    override val requestRoute: RequestRoute =
      zio.aws.s3.model.primitives.RequestRoute(impl.requestRoute())
    override val requestToken: RequestToken =
      zio.aws.s3.model.primitives.RequestToken(impl.requestToken())
    override val statusCode: Option[GetObjectResponseStatusCode] = scala
      .Option(impl.statusCode())
      .map(value =>
        zio.aws.s3.model.primitives.GetObjectResponseStatusCode(value)
      )
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.s3.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.s3.model.primitives.ErrorMessage(value))
    override val acceptRanges: Option[AcceptRanges] = scala
      .Option(impl.acceptRanges())
      .map(value => zio.aws.s3.model.primitives.AcceptRanges(value))
    override val cacheControl: Option[CacheControl] = scala
      .Option(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Option[ContentEncoding] = scala
      .Option(impl.contentEncoding())
      .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Option[ContentLanguage] = scala
      .Option(impl.contentLanguage())
      .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentLength: Option[ContentLength] = scala
      .Option(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val contentRange: Option[ContentRange] = scala
      .Option(impl.contentRange())
      .map(value => zio.aws.s3.model.primitives.ContentRange(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val deleteMarker: Option[DeleteMarker] = scala
      .Option(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val expires: Option[Expires] = scala
      .Option(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val expiration: Option[Expiration] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val missingMeta: Option[MissingMeta] = scala
      .Option(impl.missingMeta())
      .map(value => zio.aws.s3.model.primitives.MissingMeta(value))
    override val metadata: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.s3.model.primitives.MetadataKey(
              key
            ) -> zio.aws.s3.model.primitives.MetadataValue(value)
          })
          .toMap
      )
    override val objectLockMode: Option[zio.aws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockLegalHoldStatus
        : Option[zio.aws.s3.model.ObjectLockLegalHoldStatus] = scala
      .Option(impl.objectLockLegalHoldStatus())
      .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
    override val objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] =
      scala
        .Option(impl.objectLockRetainUntilDate())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
        )
    override val partsCount: Option[PartsCount] = scala
      .Option(impl.partsCount())
      .map(value => zio.aws.s3.model.primitives.PartsCount(value))
    override val replicationStatus: Option[zio.aws.s3.model.ReplicationStatus] =
      scala
        .Option(impl.replicationStatus())
        .map(value => zio.aws.s3.model.ReplicationStatus.wrap(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val restore: Option[Restore] = scala
      .Option(impl.restore())
      .map(value => zio.aws.s3.model.primitives.Restore(value))
    override val serverSideEncryption
        : Option[zio.aws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val ssekmsKeyId: Option[SSEKMSKeyId] = scala
      .Option(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val tagCount: Option[TagCount] = scala
      .Option(impl.tagCount())
      .map(value => zio.aws.s3.model.primitives.TagCount(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val bucketKeyEnabled: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ): zio.aws.s3.model.WriteGetObjectResponseRequest.ReadOnly = new Wrapper(impl)
}
