package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  MultipartUploadId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AbortMultipartUploadRequest(
    bucket: BucketName,
    key: ObjectKey,
    uploadId: MultipartUploadId,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest = {
    import AbortMultipartUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AbortMultipartUploadRequest.ReadOnly =
    zio.aws.s3.model.AbortMultipartUploadRequest.wrap(buildAwsValue())
}
object AbortMultipartUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AbortMultipartUploadRequest =
      zio.aws.s3.model.AbortMultipartUploadRequest(
        bucket,
        key,
        uploadId,
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def uploadId: MultipartUploadId
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest
  ) extends zio.aws.s3.model.AbortMultipartUploadRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest
  ): zio.aws.s3.model.AbortMultipartUploadRequest.ReadOnly = new Wrapper(impl)
}
