package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ArchiveStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.ArchiveStatus
}
object ArchiveStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ArchiveStatus
  ): zio.aws.s3.model.ArchiveStatus = value match {
    case software.amazon.awssdk.services.s3.model.ArchiveStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ArchiveStatus.ARCHIVE_ACCESS =>
      val r = ARCHIVE_ACCESS
      r
    case software.amazon.awssdk.services.s3.model.ArchiveStatus.DEEP_ARCHIVE_ACCESS =>
      val r = DEEP_ARCHIVE_ACCESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ArchiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ArchiveStatus =
      software.amazon.awssdk.services.s3.model.ArchiveStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ARCHIVE_ACCESS extends zio.aws.s3.model.ArchiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ArchiveStatus =
      software.amazon.awssdk.services.s3.model.ArchiveStatus.ARCHIVE_ACCESS
  }
  case object DEEP_ARCHIVE_ACCESS extends zio.aws.s3.model.ArchiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ArchiveStatus =
      software.amazon.awssdk.services.s3.model.ArchiveStatus.DEEP_ARCHIVE_ACCESS
  }
}
