package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ChecksumMode {
  def unwrap: software.amazon.awssdk.services.s3.model.ChecksumMode
}
object ChecksumMode {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ChecksumMode
  ): zio.aws.s3.model.ChecksumMode = value match {
    case software.amazon.awssdk.services.s3.model.ChecksumMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ChecksumMode.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ChecksumMode {
    override def unwrap: software.amazon.awssdk.services.s3.model.ChecksumMode =
      software.amazon.awssdk.services.s3.model.ChecksumMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.s3.model.ChecksumMode {
    override def unwrap: software.amazon.awssdk.services.s3.model.ChecksumMode =
      software.amazon.awssdk.services.s3.model.ChecksumMode.ENABLED
  }
}
