package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ChecksumSHA256,
  ChecksumCRC32C,
  ObjectKey,
  ChecksumCRC32,
  ChecksumSHA1,
  BucketName,
  MultipartUploadId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompleteMultipartUploadRequest(
    bucket: BucketName,
    key: ObjectKey,
    multipartUpload: Option[zio.aws.s3.model.CompletedMultipartUpload] = None,
    uploadId: MultipartUploadId,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None,
    requestPayer: Option[zio.aws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest = {
    import CompleteMultipartUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(multipartUpload.map(value => value.buildAwsValue()))(
        _.multipartUpload
      )
      .uploadId(MultipartUploadId.unwrap(uploadId): java.lang.String)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CompleteMultipartUploadRequest.ReadOnly =
    zio.aws.s3.model.CompleteMultipartUploadRequest.wrap(buildAwsValue())
}
object CompleteMultipartUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CompleteMultipartUploadRequest =
      zio.aws.s3.model.CompleteMultipartUploadRequest(
        bucket,
        key,
        multipartUpload.map(value => value.asEditable),
        uploadId,
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def multipartUpload
        : Option[zio.aws.s3.model.CompletedMultipartUpload.ReadOnly]
    def uploadId: MultipartUploadId
    def checksumCRC32: Option[ChecksumCRC32]
    def checksumCRC32C: Option[ChecksumCRC32C]
    def checksumSHA1: Option[ChecksumSHA1]
    def checksumSHA256: Option[ChecksumSHA256]
    def requestPayer: Option[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Option[AccountId]
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMultipartUpload: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.CompletedMultipartUpload.ReadOnly
    ] = AwsError.unwrapOptionField("multipartUpload", multipartUpload)
    def getUploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadId)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
  ) extends zio.aws.s3.model.CompleteMultipartUploadRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val multipartUpload
        : Option[zio.aws.s3.model.CompletedMultipartUpload.ReadOnly] = scala
      .Option(impl.multipartUpload())
      .map(value => zio.aws.s3.model.CompletedMultipartUpload.wrap(value))
    override val uploadId: MultipartUploadId =
      zio.aws.s3.model.primitives.MultipartUploadId(impl.uploadId())
    override val checksumCRC32: Option[ChecksumCRC32] = scala
      .Option(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Option[ChecksumCRC32C] = scala
      .Option(impl.checksumCRC32C())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Option[ChecksumSHA1] = scala
      .Option(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Option[ChecksumSHA256] = scala
      .Option(impl.checksumSHA256())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
    override val requestPayer: Option[zio.aws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
  ): zio.aws.s3.model.CompleteMultipartUploadRequest.ReadOnly = new Wrapper(
    impl
  )
}
