package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ETag,
  ChecksumSHA256,
  LastModified,
  ChecksumCRC32C,
  ChecksumCRC32,
  ChecksumSHA1
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CopyObjectResult(
    eTag: Option[ETag] = None,
    lastModified: Option[LastModified] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectResult = {
    import CopyObjectResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectResult
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CopyObjectResult.ReadOnly =
    zio.aws.s3.model.CopyObjectResult.wrap(buildAwsValue())
}
object CopyObjectResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CopyObjectResult =
      zio.aws.s3.model.CopyObjectResult(
        eTag.map(value => value),
        lastModified.map(value => value),
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value)
      )
    def eTag: Option[ETag]
    def lastModified: Option[LastModified]
    def checksumCRC32: Option[ChecksumCRC32]
    def checksumCRC32C: Option[ChecksumCRC32C]
    def checksumSHA1: Option[ChecksumSHA1]
    def checksumSHA256: Option[ChecksumSHA256]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResult
  ) extends zio.aws.s3.model.CopyObjectResult.ReadOnly {
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val checksumCRC32: Option[ChecksumCRC32] = scala
      .Option(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Option[ChecksumCRC32C] = scala
      .Option(impl.checksumCRC32C())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Option[ChecksumSHA1] = scala
      .Option(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Option[ChecksumSHA256] = scala
      .Option(impl.checksumSHA256())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResult
  ): zio.aws.s3.model.CopyObjectResult.ReadOnly = new Wrapper(impl)
}
