package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  GrantRead,
  GrantReadACP,
  ObjectLockEnabledForBucket,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  GrantWrite
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketRequest(
    acl: Option[zio.aws.s3.model.BucketCannedACL] = None,
    bucket: BucketName,
    createBucketConfiguration: Option[
      zio.aws.s3.model.CreateBucketConfiguration
    ] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWrite: Option[GrantWrite] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    objectLockEnabledForBucket: Option[ObjectLockEnabledForBucket] = None,
    objectOwnership: Option[zio.aws.s3.model.ObjectOwnership] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        createBucketConfiguration.map(value => value.buildAwsValue())
      )(_.createBucketConfiguration)
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWrite.map(value => GrantWrite.unwrap(value): java.lang.String)
      )(_.grantWrite)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .optionallyWith(
        objectLockEnabledForBucket.map(value =>
          ObjectLockEnabledForBucket.unwrap(value): java.lang.Boolean
        )
      )(_.objectLockEnabledForBucket)
      .optionallyWith(objectOwnership.map(value => value.unwrap))(
        _.objectOwnership
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CreateBucketRequest.ReadOnly =
    zio.aws.s3.model.CreateBucketRequest.wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CreateBucketRequest =
      zio.aws.s3.model.CreateBucketRequest(
        acl.map(value => value),
        bucket,
        createBucketConfiguration.map(value => value.asEditable),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWrite.map(value => value),
        grantWriteACP.map(value => value),
        objectLockEnabledForBucket.map(value => value),
        objectOwnership.map(value => value)
      )
    def acl: Option[zio.aws.s3.model.BucketCannedACL]
    def bucket: BucketName
    def createBucketConfiguration
        : Option[zio.aws.s3.model.CreateBucketConfiguration.ReadOnly]
    def grantFullControl: Option[GrantFullControl]
    def grantRead: Option[GrantRead]
    def grantReadACP: Option[GrantReadACP]
    def grantWrite: Option[GrantWrite]
    def grantWriteACP: Option[GrantWriteACP]
    def objectLockEnabledForBucket: Option[ObjectLockEnabledForBucket]
    def objectOwnership: Option[zio.aws.s3.model.ObjectOwnership]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.BucketCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getCreateBucketConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.CreateBucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createBucketConfiguration",
      createBucketConfiguration
    )
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWrite)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getObjectLockEnabledForBucket
        : ZIO[Any, AwsError, ObjectLockEnabledForBucket] =
      AwsError.unwrapOptionField(
        "objectLockEnabledForBucket",
        objectLockEnabledForBucket
      )
    def getObjectOwnership
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectOwnership] =
      AwsError.unwrapOptionField("objectOwnership", objectOwnership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ) extends zio.aws.s3.model.CreateBucketRequest.ReadOnly {
    override val acl: Option[zio.aws.s3.model.BucketCannedACL] = scala
      .Option(impl.acl())
      .map(value => zio.aws.s3.model.BucketCannedACL.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val createBucketConfiguration
        : Option[zio.aws.s3.model.CreateBucketConfiguration.ReadOnly] = scala
      .Option(impl.createBucketConfiguration())
      .map(value => zio.aws.s3.model.CreateBucketConfiguration.wrap(value))
    override val grantFullControl: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Option[GrantRead] = scala
      .Option(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Option[GrantReadACP] = scala
      .Option(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWrite: Option[GrantWrite] = scala
      .Option(impl.grantWrite())
      .map(value => zio.aws.s3.model.primitives.GrantWrite(value))
    override val grantWriteACP: Option[GrantWriteACP] = scala
      .Option(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val objectLockEnabledForBucket
        : Option[ObjectLockEnabledForBucket] = scala
      .Option(impl.objectLockEnabledForBucket())
      .map(value =>
        zio.aws.s3.model.primitives.ObjectLockEnabledForBucket(value)
      )
    override val objectOwnership: Option[zio.aws.s3.model.ObjectOwnership] =
      scala
        .Option(impl.objectOwnership())
        .map(value => zio.aws.s3.model.ObjectOwnership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ): zio.aws.s3.model.CreateBucketRequest.ReadOnly = new Wrapper(impl)
}
