package zio.aws.s3.model
import zio.aws.s3.model.primitives.Location
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketResponse(location: Option[Location] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketResponse = {
    import CreateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketResponse
      .builder()
      .optionallyWith(
        location.map(value => Location.unwrap(value): java.lang.String)
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CreateBucketResponse.ReadOnly =
    zio.aws.s3.model.CreateBucketResponse.wrap(buildAwsValue())
}
object CreateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CreateBucketResponse =
      zio.aws.s3.model.CreateBucketResponse(location.map(value => value))
    def location: Option[Location]
    def getLocation: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketResponse
  ) extends zio.aws.s3.model.CreateBucketResponse.ReadOnly {
    override val location: Option[Location] = scala
      .Option(impl.location())
      .map(value => zio.aws.s3.model.primitives.Location(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketResponse
  ): zio.aws.s3.model.CreateBucketResponse.ReadOnly = new Wrapper(impl)
}
