package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteObjectsResponse(
    deleted: Option[Iterable[zio.aws.s3.model.DeletedObject]] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None,
    errors: Option[Iterable[zio.aws.s3.model.S3Error]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectsResponse = {
    import DeleteObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
      .builder()
      .optionallyWith(
        deleted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleted)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectsResponse.ReadOnly =
    zio.aws.s3.model.DeleteObjectsResponse.wrap(buildAwsValue())
}
object DeleteObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectsResponse =
      zio.aws.s3.model.DeleteObjectsResponse(
        deleted.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestCharged.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deleted: Option[List[zio.aws.s3.model.DeletedObject.ReadOnly]]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def errors: Option[List[zio.aws.s3.model.S3Error.ReadOnly]]
    def getDeleted
        : ZIO[Any, AwsError, List[zio.aws.s3.model.DeletedObject.ReadOnly]] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getErrors: ZIO[Any, AwsError, List[zio.aws.s3.model.S3Error.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
  ) extends zio.aws.s3.model.DeleteObjectsResponse.ReadOnly {
    override val deleted
        : Option[List[zio.aws.s3.model.DeletedObject.ReadOnly]] = scala
      .Option(impl.deleted())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.DeletedObject.wrap(item)
        }.toList
      )
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val errors: Option[List[zio.aws.s3.model.S3Error.ReadOnly]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.S3Error.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
  ): zio.aws.s3.model.DeleteObjectsResponse.ReadOnly = new Wrapper(impl)
}
