package zio.aws.s3.model
import zio.aws.s3.model.primitives.FilterRuleValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FilterRule(
    name: Option[zio.aws.s3.model.FilterRuleName] = None,
    value: Option[FilterRuleValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.FilterRule = {
    import FilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.FilterRule
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => FilterRuleValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.FilterRule.ReadOnly =
    zio.aws.s3.model.FilterRule.wrap(buildAwsValue())
}
object FilterRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.FilterRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.FilterRule = zio.aws.s3.model
      .FilterRule(name.map(value => value), value.map(value => value))
    def name: Option[zio.aws.s3.model.FilterRuleName]
    def value: Option[FilterRuleValue]
    def getName: ZIO[Any, AwsError, zio.aws.s3.model.FilterRuleName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, FilterRuleValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.FilterRule
  ) extends zio.aws.s3.model.FilterRule.ReadOnly {
    override val name: Option[zio.aws.s3.model.FilterRuleName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3.model.FilterRuleName.wrap(value))
    override val value: Option[FilterRuleValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.s3.model.primitives.FilterRuleValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.FilterRule
  ): zio.aws.s3.model.FilterRule.ReadOnly = new Wrapper(impl)
}
