package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketAnalyticsConfigurationResponse(
    analyticsConfiguration: Option[zio.aws.s3.model.AnalyticsConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse = {
    import GetBucketAnalyticsConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
      .builder()
      .optionallyWith(
        analyticsConfiguration.map(value => value.buildAwsValue())
      )(_.analyticsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketAnalyticsConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse =
      zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse(
        analyticsConfiguration.map(value => value.asEditable)
      )
    def analyticsConfiguration
        : Option[zio.aws.s3.model.AnalyticsConfiguration.ReadOnly]
    def getAnalyticsConfiguration
        : ZIO[Any, AwsError, zio.aws.s3.model.AnalyticsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "analyticsConfiguration",
        analyticsConfiguration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly {
    override val analyticsConfiguration
        : Option[zio.aws.s3.model.AnalyticsConfiguration.ReadOnly] = scala
      .Option(impl.analyticsConfiguration())
      .map(value => zio.aws.s3.model.AnalyticsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
  ): zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
