package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketLifecycleConfigurationResponse(
    rules: Option[Iterable[zio.aws.s3.model.LifecycleRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse = {
    import GetBucketLifecycleConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketLifecycleConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketLifecycleConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketLifecycleConfigurationResponse =
      zio.aws.s3.model.GetBucketLifecycleConfigurationResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Option[List[zio.aws.s3.model.LifecycleRule.ReadOnly]]
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.LifecycleRule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly {
    override val rules: Option[List[zio.aws.s3.model.LifecycleRule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.LifecycleRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
  ): zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
