package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketLocationResponse(
    locationConstraint: Option[zio.aws.s3.model.BucketLocationConstraint] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketLocationResponse = {
    import GetBucketLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketLocationResponse
      .builder()
      .optionallyWith(locationConstraint.map(value => value.unwrap))(
        _.locationConstraint
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketLocationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketLocationResponse.wrap(buildAwsValue())
}
object GetBucketLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketLocationResponse =
      zio.aws.s3.model
        .GetBucketLocationResponse(locationConstraint.map(value => value))
    def locationConstraint: Option[zio.aws.s3.model.BucketLocationConstraint]
    def getLocationConstraint
        : ZIO[Any, AwsError, zio.aws.s3.model.BucketLocationConstraint] =
      AwsError.unwrapOptionField("locationConstraint", locationConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLocationResponse
  ) extends zio.aws.s3.model.GetBucketLocationResponse.ReadOnly {
    override val locationConstraint
        : Option[zio.aws.s3.model.BucketLocationConstraint] = scala
      .Option(impl.locationConstraint())
      .map(value => zio.aws.s3.model.BucketLocationConstraint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLocationResponse
  ): zio.aws.s3.model.GetBucketLocationResponse.ReadOnly = new Wrapper(impl)
}
