package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketVersioningResponse(
    status: Option[zio.aws.s3.model.BucketVersioningStatus] = None,
    mfaDelete: Option[zio.aws.s3.model.MFADeleteStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse = {
    import GetBucketVersioningResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mfaDelete.map(value => value.unwrap))(_.mfaDelete)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly =
    zio.aws.s3.model.GetBucketVersioningResponse.wrap(buildAwsValue())
}
object GetBucketVersioningResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketVersioningResponse =
      zio.aws.s3.model.GetBucketVersioningResponse(
        status.map(value => value),
        mfaDelete.map(value => value)
      )
    def status: Option[zio.aws.s3.model.BucketVersioningStatus]
    def mfaDelete: Option[zio.aws.s3.model.MFADeleteStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.s3.model.BucketVersioningStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMfaDelete: ZIO[Any, AwsError, zio.aws.s3.model.MFADeleteStatus] =
      AwsError.unwrapOptionField("mfaDelete", mfaDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
  ) extends zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly {
    override val status: Option[zio.aws.s3.model.BucketVersioningStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3.model.BucketVersioningStatus.wrap(value))
    override val mfaDelete: Option[zio.aws.s3.model.MFADeleteStatus] = scala
      .Option(impl.mfaDelete())
      .map(value => zio.aws.s3.model.MFADeleteStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
  ): zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly = new Wrapper(impl)
}
