package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketWebsiteRequest(
    bucket: BucketName,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest = {
    import GetBucketWebsiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketWebsiteRequest.ReadOnly =
    zio.aws.s3.model.GetBucketWebsiteRequest.wrap(buildAwsValue())
}
object GetBucketWebsiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketWebsiteRequest = zio.aws.s3.model
      .GetBucketWebsiteRequest(bucket, expectedBucketOwner.map(value => value))
    def bucket: BucketName
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest
  ) extends zio.aws.s3.model.GetBucketWebsiteRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest
  ): zio.aws.s3.model.GetBucketWebsiteRequest.ReadOnly = new Wrapper(impl)
}
