package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketWebsiteResponse(
    redirectAllRequestsTo: Option[zio.aws.s3.model.RedirectAllRequestsTo] =
      None,
    indexDocument: Option[zio.aws.s3.model.IndexDocument] = None,
    errorDocument: Option[zio.aws.s3.model.ErrorDocument] = None,
    routingRules: Option[Iterable[zio.aws.s3.model.RoutingRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse = {
    import GetBucketWebsiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
      .builder()
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(indexDocument.map(value => value.buildAwsValue()))(
        _.indexDocument
      )
      .optionallyWith(errorDocument.map(value => value.buildAwsValue()))(
        _.errorDocument
      )
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly =
    zio.aws.s3.model.GetBucketWebsiteResponse.wrap(buildAwsValue())
}
object GetBucketWebsiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketWebsiteResponse =
      zio.aws.s3.model.GetBucketWebsiteResponse(
        redirectAllRequestsTo.map(value => value.asEditable),
        indexDocument.map(value => value.asEditable),
        errorDocument.map(value => value.asEditable),
        routingRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def redirectAllRequestsTo
        : Option[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly]
    def indexDocument: Option[zio.aws.s3.model.IndexDocument.ReadOnly]
    def errorDocument: Option[zio.aws.s3.model.ErrorDocument.ReadOnly]
    def routingRules: Option[List[zio.aws.s3.model.RoutingRule.ReadOnly]]
    def getRedirectAllRequestsTo
        : ZIO[Any, AwsError, zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] =
      AwsError.unwrapOptionField("redirectAllRequestsTo", redirectAllRequestsTo)
    def getIndexDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.IndexDocument.ReadOnly] =
      AwsError.unwrapOptionField("indexDocument", indexDocument)
    def getErrorDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.ErrorDocument.ReadOnly] =
      AwsError.unwrapOptionField("errorDocument", errorDocument)
    def getRoutingRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.RoutingRule.ReadOnly]] =
      AwsError.unwrapOptionField("routingRules", routingRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ) extends zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly {
    override val redirectAllRequestsTo
        : Option[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] = scala
      .Option(impl.redirectAllRequestsTo())
      .map(value => zio.aws.s3.model.RedirectAllRequestsTo.wrap(value))
    override val indexDocument
        : Option[zio.aws.s3.model.IndexDocument.ReadOnly] = scala
      .Option(impl.indexDocument())
      .map(value => zio.aws.s3.model.IndexDocument.wrap(value))
    override val errorDocument
        : Option[zio.aws.s3.model.ErrorDocument.ReadOnly] = scala
      .Option(impl.errorDocument())
      .map(value => zio.aws.s3.model.ErrorDocument.wrap(value))
    override val routingRules
        : Option[List[zio.aws.s3.model.RoutingRule.ReadOnly]] = scala
      .Option(impl.routingRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.RoutingRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ): zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly = new Wrapper(impl)
}
