package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  MaxParts,
  PartsCount,
  NextPartNumberMarker,
  PartNumberMarker,
  IsTruncated
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetObjectAttributesParts(
    totalPartsCount: Option[PartsCount] = None,
    partNumberMarker: Option[PartNumberMarker] = None,
    nextPartNumberMarker: Option[NextPartNumberMarker] = None,
    maxParts: Option[MaxParts] = None,
    isTruncated: Option[IsTruncated] = None,
    parts: Option[Iterable[zio.aws.s3.model.ObjectPart]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAttributesParts = {
    import GetObjectAttributesParts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
      .builder()
      .optionallyWith(
        totalPartsCount.map(value => PartsCount.unwrap(value): Integer)
      )(_.totalPartsCount)
      .optionallyWith(
        partNumberMarker.map(value => PartNumberMarker.unwrap(value): Integer)
      )(_.partNumberMarker)
      .optionallyWith(
        nextPartNumberMarker.map(value =>
          NextPartNumberMarker.unwrap(value): Integer
        )
      )(_.nextPartNumberMarker)
      .optionallyWith(maxParts.map(value => MaxParts.unwrap(value): Integer))(
        _.maxParts
      )
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectAttributesParts.ReadOnly =
    zio.aws.s3.model.GetObjectAttributesParts.wrap(buildAwsValue())
}
object GetObjectAttributesParts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectAttributesParts =
      zio.aws.s3.model.GetObjectAttributesParts(
        totalPartsCount.map(value => value),
        partNumberMarker.map(value => value),
        nextPartNumberMarker.map(value => value),
        maxParts.map(value => value),
        isTruncated.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalPartsCount: Option[PartsCount]
    def partNumberMarker: Option[PartNumberMarker]
    def nextPartNumberMarker: Option[NextPartNumberMarker]
    def maxParts: Option[MaxParts]
    def isTruncated: Option[IsTruncated]
    def parts: Option[List[zio.aws.s3.model.ObjectPart.ReadOnly]]
    def getTotalPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("totalPartsCount", totalPartsCount)
    def getPartNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarker)
    def getNextPartNumberMarker: ZIO[Any, AwsError, NextPartNumberMarker] =
      AwsError.unwrapOptionField("nextPartNumberMarker", nextPartNumberMarker)
    def getMaxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxParts)
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getParts
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ObjectPart.ReadOnly]] =
      AwsError.unwrapOptionField("parts", parts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ) extends zio.aws.s3.model.GetObjectAttributesParts.ReadOnly {
    override val totalPartsCount: Option[PartsCount] = scala
      .Option(impl.totalPartsCount())
      .map(value => zio.aws.s3.model.primitives.PartsCount(value))
    override val partNumberMarker: Option[PartNumberMarker] = scala
      .Option(impl.partNumberMarker())
      .map(value => zio.aws.s3.model.primitives.PartNumberMarker(value))
    override val nextPartNumberMarker: Option[NextPartNumberMarker] = scala
      .Option(impl.nextPartNumberMarker())
      .map(value => zio.aws.s3.model.primitives.NextPartNumberMarker(value))
    override val maxParts: Option[MaxParts] = scala
      .Option(impl.maxParts())
      .map(value => zio.aws.s3.model.primitives.MaxParts(value))
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val parts: Option[List[zio.aws.s3.model.ObjectPart.ReadOnly]] =
      scala
        .Option(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.ObjectPart.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ): zio.aws.s3.model.GetObjectAttributesParts.ReadOnly = new Wrapper(impl)
}
