package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ETag,
  DeleteMarker,
  LastModified,
  ObjectVersionId,
  ObjectSize
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetObjectAttributesResponse(
    deleteMarker: Option[DeleteMarker] = None,
    lastModified: Option[LastModified] = None,
    versionId: Option[ObjectVersionId] = None,
    requestCharged: Option[zio.aws.s3.model.RequestCharged] = None,
    eTag: Option[ETag] = None,
    checksum: Option[zio.aws.s3.model.Checksum] = None,
    objectParts: Option[zio.aws.s3.model.GetObjectAttributesParts] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None,
    objectSize: Option[ObjectSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse = {
    import GetObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
      .builder()
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(checksum.map(value => value.buildAwsValue()))(_.checksum)
      .optionallyWith(objectParts.map(value => value.buildAwsValue()))(
        _.objectParts
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        objectSize.map(value => ObjectSize.unwrap(value): java.lang.Long)
      )(_.objectSize)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly =
    zio.aws.s3.model.GetObjectAttributesResponse.wrap(buildAwsValue())
}
object GetObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectAttributesResponse =
      zio.aws.s3.model.GetObjectAttributesResponse(
        deleteMarker.map(value => value),
        lastModified.map(value => value),
        versionId.map(value => value),
        requestCharged.map(value => value),
        eTag.map(value => value),
        checksum.map(value => value.asEditable),
        objectParts.map(value => value.asEditable),
        storageClass.map(value => value),
        objectSize.map(value => value)
      )
    def deleteMarker: Option[DeleteMarker]
    def lastModified: Option[LastModified]
    def versionId: Option[ObjectVersionId]
    def requestCharged: Option[zio.aws.s3.model.RequestCharged]
    def eTag: Option[ETag]
    def checksum: Option[zio.aws.s3.model.Checksum.ReadOnly]
    def objectParts: Option[zio.aws.s3.model.GetObjectAttributesParts.ReadOnly]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def objectSize: Option[ObjectSize]
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getChecksum: ZIO[Any, AwsError, zio.aws.s3.model.Checksum.ReadOnly] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getObjectParts: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.GetObjectAttributesParts.ReadOnly
    ] = AwsError.unwrapOptionField("objectParts", objectParts)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getObjectSize: ZIO[Any, AwsError, ObjectSize] =
      AwsError.unwrapOptionField("objectSize", objectSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ) extends zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly {
    override val deleteMarker: Option[DeleteMarker] = scala
      .Option(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val requestCharged: Option[zio.aws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val checksum: Option[zio.aws.s3.model.Checksum.ReadOnly] = scala
      .Option(impl.checksum())
      .map(value => zio.aws.s3.model.Checksum.wrap(value))
    override val objectParts
        : Option[zio.aws.s3.model.GetObjectAttributesParts.ReadOnly] = scala
      .Option(impl.objectParts())
      .map(value => zio.aws.s3.model.GetObjectAttributesParts.wrap(value))
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val objectSize: Option[ObjectSize] = scala
      .Option(impl.objectSize())
      .map(value => zio.aws.s3.model.primitives.ObjectSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ): zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly = new Wrapper(impl)
}
